/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block.be;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.railwayteam.railways.content.smokestack.ISpeedNotifiable;
import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class DieselSmokeStackBlockEntity
extends SmartBlockEntity
implements ISpeedNotifiable {
    private LerpedFloat rpmLimiter;
    private double fanRotation;
    private double lastRotateTime;
    private double notifiedSpeed;

    public DieselSmokeStackBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public double getRpm(float partialTicks) {
        boolean enabled = (Boolean)this.method_11010().method_11654((class_2769)SmokeStackBlock.ENABLED);
        if (this.rpmLimiter == null) {
            this.rpmLimiter = LerpedFloat.linear().startWithValue(enabled ? 1.0 : 0.0);
        }
        this.rpmLimiter.chase(enabled ? 1.0 : 0.0, 0.05, LerpedFloat.Chaser.EXP);
        double speed = 32.0;
        if (this.field_11863 instanceof ContraptionWorld || this.field_11863 instanceof VirtualRenderWorld) {
            speed = this.notifiedSpeed;
        }
        return speed * (double)this.rpmLimiter.getValue(partialTicks);
    }

    public void tick() {
        super.tick();
        if (this.rpmLimiter != null) {
            this.rpmLimiter.tickChaser();
        }
    }

    public double getFanRotation(double rpm) {
        double currentTime = this.field_11863 == null ? 0.0 : (double)AnimationTickHolder.getRenderTime((class_1936)this.field_11863);
        double delta = currentTime - this.lastRotateTime;
        this.lastRotateTime += delta;
        double movementAmt = delta / 20.0 / 60.0 * rpm * 360.0;
        this.fanRotation += movementAmt;
        while (this.fanRotation > 360.0) {
            this.fanRotation -= 360.0;
        }
        while (this.fanRotation < 0.0) {
            this.fanRotation += 360.0;
        }
        return this.fanRotation;
    }

    @Override
    public void notifySpeed(double speed) {
        this.notifiedSpeed = 112.0 / (1.0 + Math.pow(2.0, -16.0 * speed + 10.0)) + 48.0;
    }
}

